<?php include "header.php";

if (isset($_GET['transcid'])) {
    $transcid = $_GET['transcid'];
} else {
    header('Location: ' . $_SERVER['HTTP_REFERER']);
}

?>
<title>Transaction details</title>
<main class="py-5 mt-5" id="content">
    <div class="container">
        <?php
            $select = $db_conn->prepare("SELECT * FROM nfthistory WHERE transc_id = :transc_id");
            $select->bindParam(':transc_id', $transcid, PDO::PARAM_STR);
            $select->execute();
            if ($select->rowCount() < 1) {
                header('Location: ' . $_SERVER['HTTP_REFERER']);
                exit();
            } else {
                $row = $select->fetch(PDO::FETCH_ASSOC);
                $mem_id = $row['mem_id'];
            }
        ?>
        <div class="card border border-1 border-primary">
            <div class="card-body">
                <h5 class="text-center mb-4 text-uppercase">Nft Purchase Details</h5>
                <div class="border-bottom border-4 w-50 mb-4 me-auto ms-auto"></div>
                <div class="">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="fw-bold w-100">
                            <h6 class="fw-bold">Amount: </h6>
                        </div>
                        <div class="w-100">
                            <p class="">$<?= number_format($row['amount'], 2); ?></p>
                        </div>
                    </div>
                    <div class="border-bottom border-2 mb-4"></div>
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="fw-bold w-100">
                            <h6 class="fw-bold">Payment method: </h6>
                        </div>
                        <div class="text-start w-100">
                            <p class=""><?= $row['method']; ?></p>
                        </div>
                    </div>
                    <div class="border-bottom border-2 mb-4"></div>
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="fw-bold w-100">
                            <h6 class="fw-bold">Purchase Date: </h6>
                        </div>
                        <div class="w-100">
                            <p class="fw-bold"><?= $row['addeddate']; ?></p>
                        </div>
                    </div>
                    <div class="border-bottom border-2 mb-4"></div>
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="fw-bold w-100">
                            <h6 class="fw-bold">View NFT: </h6>
                        </div>
                        <div class="w-100">
                            <a class="btn btn-sm btn-primary" target="_blank" href="./nft?nftid=<?= $row['nft_id']; ?>"> Open</a>
                        </div>
                    </div>
                    <div class="border-bottom border-2 mb-4"></div>
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="fw-bold w-100">
                            <h6 class="fw-bold">Payment proof: </h6>
                        </div>
                        <div class="w-100">
                            <a class="btn btn-sm btn-primary" target="_blank" href="../../assets/images/proof/<?= $row['proof']; ?>"> view</a>
                        </div>
                    </div>
                    <div class="border-bottom border-2 mb-4"></div>
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="fw-bold w-100">
                            <h6 class="fw-bold">Status: </h6>
                        </div>
                        <div class="w-100">
                            <p class="fw-bold"><?= $row['status'] == 0 ? '<span class="text-warning">Processing</span>' : ($row['status'] == 1 ? '<span class="text-success">Completed</span>' : '<span class="text-danger">Failed</span>'); ?></p>
                        </div>
                    </div>
                    <div class="border-bottom border-2 mb-4"></div>
                </div>
                <h4 class="fw-bold text-center">Make changes</h4>
				<hr>
				<form id="upgrade" enctype="multipart/form-data" method="POST">
					<div class="my-3 me-auto ms-auto">
						<p class="alert alert-primary" id="errorshows"></p>
					</div>
					<div class="select-wrapper my-3">
					    <select class="select" name="status" id="status" required="">
							<option disabled selected>--Select Duration--</option>
							<option <?= $row['status'] == 0 ? 'selected' : ''; ?> value="0">Pending</option>
							<option <?= $row['status'] == 1 ? 'selected' : ''; ?> value="1">Approve</option>
							<option <?= $row['status'] == 2 ? 'selected' : ''; ?> value="2">Failed</option>
						</select>
					</div>
					<div class="my-3" align="center">
						<button type="submit" class="btn btn-md btn-primary btn-rounded">Submit</button>
					</div>
				</form>
            </div>
        </div>
    </div>
</main>
<?php include "footer.php"; ?>
<script>
	$(document).ready(function() {
		$("#errorshows").fadeOut();
	});
	
	$("form#upgrade").submit(function(e) {
		e.preventDefault();
		var formData = new FormData(this);
		var request = "approveNfts";
		var mem_id = "<?= $mem_id; ?>";
		var transc_id = "<?= $transcid; ?>";
		formData.append('request', request);
		formData.append('mem_id', mem_id);
		formData.append('transc_id', transc_id);
		$.ajax({
			url: '../../ops/adminauth',
			type: 'POST',
			data: formData,
			beforeSend: function() {
				$('#errorshows').html("Please wait <span class='fas fa-1x fa-spinner fa-spin'></span>").fadeIn();
			},
			success: function(data) {
				if (data == "success") {
					$('#errorshows').html("<span class='fas fa-check-circle'></span> Updated successfully").fadeIn();
					setTimeout(function() {
						location.reload();
					}, 3000)
				} else {
					$("#errorshows").html("<span class='fas fa-exclamation-triangle'></span> " + data).fadeIn();
				}
			},
			cache: false,
			error: function(err) {
				$('#errorshows').html("<span class='fas fa-exclamation-triangle'></span> An error has occured!!" + err).fadeIn();
			},
			contentType: false,
			processData: false
		});
	});

</script>

